global rolloutSteamRoller
	
	fn flattentheUVs m myAngle mySpacing =
	(
		resumeEditing()
		max modify mode
		addModifier m (Unwrap_UVW ()) ui:on
		m.modifiers[#unwrap_uvw].setMapChannel 3
		modPanel.setCurrentObject m.modifiers[#Unwrap_UVW]
		subobjectLevel = 3
		actionMan.executeAction 0 "40021"
		max create mode
		m.modifiers[#unwrap_uvw].flattenMap 45 #() 0.005 true 0 true true
		m.modifiers[#unwrap_uvw].unwrap4.setThickOpenEdges false
	)
	
	fn runNow = 
	(
		resumeEditing()
		progressStart "Unwrapping Models"
		 
		theAngle = rolloutSteamRoller.spnAngle.value
		theSpacing = rolloutSteamRoller.spnSpacing.value
		--progressStart "Unwrapping"
		num = 1.0
		theModels = for s in selection collect s
		size = (theModels.count as float)
		for m in theModels do
		(
			progPercent = num/theModels.count * 100.0
			progressUpdate progPercent			
			test = (GetTriMeshFaceCount m)
			if (test[1] != 0 and test != undefined) then flattentheUVs m theAngle theSpacing -- if the model contians geometry, flatten it
			num = num + 1
		)
		--rolloutSteamRoller.pBarPercent.value = 0
		max modify mode
		progressEnd()
		resumeEditing()
	)
	
	fn getSurfaceArea = 
	(
		for s in selection do () 
	)
	
	rollout rolloutSteamRoller "Flatten Unwrap"
	(
		label lblInof "Unwrap Current Selection"
		spinner spnAngle "Angle:" range:[0,180,45] align:#center
		spinner spnSpacing "Spacing:" range:[0,1,0.005] align:#center
	--	checkbox chkByMaterialIDs "By Material IDs?" align:#center checked:false
	--	checkbox chkSelection "Use Selection" align:#center checked:true
		button btnUnwrap "Unwrap Now" align:#center
		--button btnSurfaceArea "Calculate Surface Area" align:#center
		on btnUnwrap pressed do runNow()
		--on btnSurfaceArea pressed do messageBox  "surface area pressed"
	)
	
	try (destroyDialog rolloutSteamRoller) catch()
	createDialog rolloutSteamRoller height:100